/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.integration.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class CauldronCategory
implements IRecipeCategory<CauldronRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ftbsbc:cauldron");
    private final Component title = new TranslatableComponent("block.minecraft.cauldron");
    private final IDrawable background;
    private final IDrawable icon;

    public CauldronCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("ftbsbc:textures/cauldron.png"), 0, 0, 112, 30).setTextureSize(128, 64).build();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42544_));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CauldronRecipe> getRecipeClass() {
        return CauldronRecipe.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CauldronRecipe recipe, List<? extends IFocus<?>> focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 7).addIngredients(VanillaTypes.ITEM, recipe.input());
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 7).addIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42544_));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 7).addIngredient(VanillaTypes.FLUID, (Object)recipe.output());
    }

    public record CauldronRecipe(List<ItemStack> input, FluidStack output) {
    }
}

